package editor;

import game.CustomImageDataII;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CharacterListItem extends JPanel {
	
	private JLabel characterIconLabel;
	
	private JLabel nameLabel;
	
	private JButton keyChangeButton;
	
	private JButton editButton;
	
	private char activateKey;
	
	private String dataArray[];
	
	private ImageIcon defaultIcon;
	
	private CharacterList parent;
	
	public CharacterListItem(String [] theDataArray, char theKey, ImageIcon theDefaultIcon, CharacterList theParent) {
		
		super();
		
		activateKey = theKey;
		dataArray = theDataArray;
		this.defaultIcon = theDefaultIcon;
		parent = theParent;
		
		String iconImage = null;
		String charName = "(no name yet)";
		
		String s;
		
		for(int i = 0; i < theDataArray.length; i++) {
			
			s = theDataArray[i];
			
			if(s.contains("CharName:")) {
				if(s.substring(9).trim().length() > 0) {
					charName = s.substring(9).trim();
				}
			} else if(iconImage == null) {
				
				if(s.contains("RightStandAnim:") && s.charAt(15) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("RightWalkAnim:") && s.charAt(14) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("RightAirAnim:") && s.charAt(13) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftStandAnim:") && s.charAt(14) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftWalkAnim:") && s.charAt(13) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftAirAnim:") && s.charAt(12) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				}
				
			}
			
		}
		
		
		if(iconImage == null) {
			
			characterIconLabel = new JLabel(theDefaultIcon);
			
		} else {
			
			CustomImageDataII im = PlayerCharacterEditorPanel.convertStringToImage(iconImage, this);
			
			if(im == null || im.getImage() == null) {
				characterIconLabel = new JLabel(theDefaultIcon);
			} else {
			
				ImageIcon icon = new ImageIcon(im.getImage());
				
				characterIconLabel = new JLabel(icon);
			}
			
		}
		
		
		
		this.setLayout(new GridBagLayout());
		
		GridBagConstraints c = new GridBagConstraints();
		
		
		c.weightx = 0.5;
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 10, 0);
		c.anchor = GridBagConstraints.LINE_START;
		
		
		this.add(characterIconLabel, c);
		
		c.gridx = 1;
		c.gridwidth = 3;
		
		nameLabel = new JLabel(charName);
		
		this.add(nameLabel, c);
		
		keyChangeButton = new JButton("<html><div align='center'>key: <b>" + activateKey + "</b><br><font size='1'>(click to change)</font></div></html>");
		keyChangeButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				while(true) {
					char newChar = CharacterListItem.popUpCharacterSelectDialog(activateKey);
					
					if(newChar == activateKey || newChar == '\0')
						return;
					else if(parent.activationKeyTaken(newChar)) {
						int retry = JOptionPane.showConfirmDialog(null, "That key, " + Character.toString(newChar) + ", is already taken by another character.  Pick a different key?","Error", JOptionPane.YES_NO_OPTION);
						if(retry != JOptionPane.YES_OPTION)
							return;
					} else {
						//we have a good one
						activateKey = newChar;
						
						keyChangeButton.setText("<html><div align='center'>key: <b>" + activateKey + "</b><br><font size='1'>(click to change)</font></div></html>");
						
						return;
						
					}
					
				}
				
			}
		});
		Dimension summaryButtonSize = new Dimension(70, 40);
		keyChangeButton.setPreferredSize(summaryButtonSize);
		keyChangeButton.setPreferredSize(summaryButtonSize);
		keyChangeButton.setPreferredSize(summaryButtonSize);
		keyChangeButton.setSize(summaryButtonSize);
		c.weightx = 0.0;
		c.gridx = 4;
		c.gridwidth = 2;
		c.insets = new Insets(0, 0, 0, 10);
		c.anchor = GridBagConstraints.LINE_END;
		
		
		this.add(keyChangeButton, c);
		
		
		c.insets = new Insets(0, 0, 0, 0);
		c.gridx = 6;
		c.gridwidth = 3;
		c.anchor = GridBagConstraints.LINE_END;
		editButton = new JButton("Edit...");
		editButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				
				
//				System.out.println("<><>DELME about to throw open an editor pane; dataArray is:");
//				for(String s : dataArray) {
//					System.out.println("<><>DELME  ^^^^^^  " + s);
//				}
				
				JDialog dialog = new JDialog();
				
				PlayerCharacterEditorPanel panel = new PlayerCharacterEditorPanel(dialog, dataArray);
				
				dialog.setContentPane(panel);
				
				dialog.setPreferredSize(new Dimension(500, 600));
				dialog.setMinimumSize(new Dimension(500, 600));
				dialog.setMaximumSize(new Dimension(500, 600));
				
				dialog.setModal(true);
				
				dialog.setVisible(true);
				
				
				if(panel.wasCancelled() || panel.getContentArray() == null)
					return;
				
				dataArrayWasChanged(panel.getContentArray());
				
				repaint();
				
			}
		});
		Dimension editButtonSize = new Dimension(70, 45);
		editButton.setPreferredSize(editButtonSize);
		editButton.setPreferredSize(editButtonSize);
		editButton.setPreferredSize(editButtonSize);
		editButton.setSize(summaryButtonSize);
		this.add(editButton, c);
		
		
		if(PlayerCharacterEditorPanel.isCompleteFieldSummary(theDataArray)) {
			this.setBackground(new Color(175, 175, 255));
			this.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 255)));
		} else {
			this.setBackground(new Color(128, 100, 75));
			this.setBorder(BorderFactory.createLineBorder(new Color(200, 150, 100)));
		}
		
		Dimension d = new Dimension(325, 100);
		this.setSize(d);
		this.setPreferredSize(d);
		this.setMinimumSize(d);
		this.setMaximumSize(d);
		
	}
	
	
	
	public void dataArrayWasChanged(String [] theDataArray) {

//		System.out.println("<><>DELME BEFORE dataArray:");
//		for(String s : dataArray) {
//			System.out.println("<><>DELME  ######  " + s);
//		}
		
		dataArray = theDataArray;

//		System.out.println("<><>DELME AFTER dataArray:");
//		for(String s : dataArray) {
//			System.out.println("<><>DELME  @@@@@@  " + s);
//		}
		
		String iconImage = null;
		String charName = "(no name yet)";
		
		String s;
		
		for(int i = 0; i < theDataArray.length; i++) {
			
			s = theDataArray[i];
			
			if(s.contains("CharName:")) {
				if(s.substring(9).trim().length() > 0) {
					charName = s.substring(9).trim();
				}
			} else if(iconImage == null) {
				
				if(s.contains("RightStandAnim:") && s.charAt(15) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("RightWalkAnim:") && s.charAt(14) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("RightAirAnim:") && s.charAt(13) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftStandAnim:") && s.charAt(14) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftWalkAnim:") && s.charAt(13) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				} else if(s.contains("LeftAirAnim:") && s.charAt(12) != '0' && !theDataArray[i + 1].contains("blank*null")) {
					iconImage = theDataArray[i + 1];
				}
				
			}
			
		}
		
		
		if(iconImage == null) {
			
			characterIconLabel.setIcon(defaultIcon);
			
		} else {
			
			CustomImageDataII im = PlayerCharacterEditorPanel.convertStringToImage(iconImage, this);
			
			ImageIcon icon = new ImageIcon(im.getImage());
			
			characterIconLabel.setIcon(icon);
			
		}
		
		
		
		nameLabel.setText(charName);
		
		
		
		if(PlayerCharacterEditorPanel.isCompleteFieldSummary(theDataArray)) {
			this.setBackground(new Color(175, 175, 255));
			this.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 255)));
		} else {
			this.setBackground(new Color(128, 100, 75));
			this.setBorder(BorderFactory.createLineBorder(new Color(200, 150, 100)));
		}
		
	}
	
	
	public char getActivateKey() {
		return activateKey;
	}
	
	
	public static char popUpCharacterSelectDialog(char initialChar) {
		
		while(true) {
			
			String rawInput = JOptionPane.showInputDialog("Input which key should be used:", initialChar == '\0' ? "" : Character.toString(initialChar));
			
			char candidateChar;
			
			if(rawInput == null)
				return '\0';
			
			if(rawInput.length() == 0) {
				int tryAgain = JOptionPane.showConfirmDialog(null, "You didn't enter anything.  Retry?", "Error", JOptionPane.YES_NO_OPTION);
				
				if(tryAgain != JOptionPane.YES_OPTION)
					return '\0';
			} else if(rawInput.length() > 1) {
				
				JOptionPane.showMessageDialog(null, "Since you entered more than one character, using the first...");
				
			}
			
			
			candidateChar = rawInput.charAt(0);
			
			if(!Character.isDigit(candidateChar) && !Character.isLetter(candidateChar)) {
				int tryAgain = JOptionPane.showConfirmDialog(null, "The given key wasn't a letter or a number:  "+Character.toString(candidateChar)+".  Retry?", "Error", JOptionPane.YES_NO_OPTION);
				
				if(tryAgain == JOptionPane.NO_OPTION)
					return '\0';
			} else {
				return Character.toUpperCase(candidateChar);
			}
			
			
		}
		
	}
	
	public String getCharacterName() {
		return nameLabel.getText();
	}
	
	public String toString() {
		return nameLabel.getText();
	}
	
	
	
	public void writeOutCharacterToFile(BufferedWriter out) throws Exception {
		
		
		if(dataArray == null || dataArray.length == 0)
			return;
		
		
		if(PlayerCharacterEditorPanel.isCompleteFieldSummary(dataArray)) {
			out.write("character:" + Character.toString(activateKey));
		} else {
			out.write("charNoCompleta:" + Character.toString(activateKey));
		}
		out.newLine();
		
		for(String s : dataArray) {
			out.write(s);
			out.newLine();
		}
		
		out.write("/character");
		out.newLine();
		
		
	}
	
	public static CharacterListItem readCharacterFromFile(BufferedReader in, char theActivationKey, ImageIcon theDefaultIcon, CharacterList theParent) throws Exception {
		
		ArrayList<String> dataList = new ArrayList<String>();
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			
			if(inputter.trim().equals("/character"))
				break;
			
			if(inputter.trim().equals("/characters"))
				return null;
			
			dataList.add(inputter);
		}
		
		
		return new CharacterListItem(dataList.toArray(new String[0]), theActivationKey, theDefaultIcon, theParent);
		
	}
	
}
